/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.openal.AudioLoader;
import org.newdawn.slick.openal.SoundStore;
import org.newdawn.slick.util.ResourceLoader;

public class AudioManager {
    private static final AudioManager single = new AudioManager();

    public static AudioManager get() {
        return single;
    }

    private AudioManager() {
    }

    public Audio initMusic(String file) {
        Audio audio = null;
        try {
            audio = AudioLoader.getStreamingAudio((String)"OGG", (URL)ResourceLoader.getResource((String)("resources/audio/music/" + file + ".ogg")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return audio;
    }

    public Audio initSound(String file) {
        Audio audio = null;
        try {
            audio = AudioLoader.getAudio((String)"OGG", (InputStream)ResourceLoader.getResourceAsStream((String)("resources/audio/sounds/" + file + ".ogg")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return audio;
    }

    public void playMusic(Audio audio) {
        audio.playAsMusic(1.0f, 1.0f, true);
    }

    public void playSound(Audio audio) {
        audio.playAsSoundEffect(1.0f, 1.0f, false);
    }

    public void poll() {
        SoundStore.get().poll(0);
    }

    public void setMusicVolume(float volume) {
        SoundStore.get().setMusicVolume(volume);
    }

    public void setSoundVolume(float volume) {
        SoundStore.get().setSoundVolume(volume);
    }

    public float getMusicVolume() {
        return SoundStore.get().getMusicVolume();
    }

    public float getSoundVolume() {
        return SoundStore.get().getSoundVolume();
    }

    public void cleanUp() {
        try {
            this.destroyOpenAL(new Audio[0]);
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    private void destroyOpenAL(Audio ... buffers) throws SlickException, UnsatisfiedLinkError {
        int max = SoundStore.get().getSourceCount();
        IntBuffer buf = BufferUtils.createIntBuffer((int)max);
        int i = 0;
        while (i < max) {
            int source = SoundStore.get().getSource(i);
            buf.put(source);
            this.detachBuffer(source);
            ++i;
        }
        buf.flip();
        AL10.alDeleteSources((IntBuffer)buf);
        int exc = AL10.alGetError();
        if (exc != 0) {
            throw new SlickException("Could not clear SoundStore sources, err: " + exc);
        }
        if (buffers != null) {
            Audio[] audioArray = buffers;
            int n = buffers.length;
            int n2 = 0;
            while (n2 < n) {
                Audio a = audioArray[n2];
                this.clearBuffer(a);
                ++n2;
            }
        }
        AL.destroy();
        SoundStore.get().clear();
    }

    private void clearBuffer(Audio audio) throws SlickException {
        if (audio == null || audio.getBufferID() == 0) {
            return;
        }
        IntBuffer buf = BufferUtils.createIntBuffer((int)1).put(audio.getBufferID());
        buf.flip();
        AL10.alDeleteBuffers((IntBuffer)buf);
        int exc = AL10.alGetError();
        if (exc != 0) {
            throw new SlickException("Could not clear buffer " + audio.getBufferID() + ", err: " + exc);
        }
    }

    private void detachBuffer(int sourceID) {
        AL10.alSourceStop((int)sourceID);
        AL10.alSourcei((int)sourceID, (int)4105, (int)0);
    }
}

